<?php
/*
	Stempora Web Framework
	Copyright (c) 2002-2018 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com		
*/

// dependencies

/**
* description
*
* @library	
* @author	
* @since	
*/
class CTeam extends CPlugin{
	
	var $tplvars; 

	function __construct() {
		$this->name = "team";
	}

	function DoEvents(){
		global $base, $_CONF, $_TSM , $_VARS , $_USER , $_BASE , $_SESS;


		if ($_GET["mod"] == $this->name) {
			//read the module
			$this->tpl_module = $this->module->plugins["modules"]->getModuleInfo($_GET["module_id"]);
			$this->plugins["modules"]->ValidateModule($this->tpl_module);

			parent::DoEvents();

			$sub = $_GET["sub"];
			$action = $_GET["action"];


			switch ($sub) {

				case "texts":
					return $this->__adminTexts();
				break;


				case "landing":
					$_GET["sub"] = $sub = "items";
				case "cats":
				case "fields":
					$data = new CSQLAdmin($sub , $this->__parent_templates,$this->db,$this->tables,$extra);
					$data->setAclMod($this->tpl_module);
					$this->PrepareFields($data->forms["forms"]);
					return $data->DoEvents();
				break;

				case "items":
					$data = new CSQLAdmin($sub , $this->__parent_templates,$this->db,$this->tables,$extra);
					$data->setAclMod($this->tpl_module);
					$this->PrepareFields($data->forms["forms"]);
					$this->PrepareTeamFields($data->forms["forms"]);

					$data->functions = array( 
							"onstore"			=> array(&$this , "TeamStoreFields" ),
							"ondetails"			=> array(&$this , "TeamSocialValues" ),
							"onedit"			=> array(&$this , "TeamSocialValues" ),
					);					

					return $data->DoEvents();
				break;

			}
		}
	}

	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function onCreate($module_data) {
		//execute any other standard operations
		parent::onCreate($module_data);		

		$this->CreatePageTitleBlock(array(
			"module_id"	=> $module_data["mod_id"],
			"title"		=> $module_data["mod_name"],
			"subtitle"	=> "You can edit this section in the Module Head tab",
			"show"		=> 1,
		));


		
		$fields = array(
			array(
				"module_id"		=> $module_data["mod_id"],
				"item_name"		=> "LinkedIn",
				"item_icon"		=> "icomoon icon-linkedin2",
			),
			array(
				"module_id"		=> $module_data["mod_id"],
				"item_name"		=> "Twitter",
				"item_icon"		=> "icomoon icon-twitter",
			),
			array(
				"module_id"		=> $module_data["mod_id"],
				"item_name"		=> "Facebook",
				"item_icon"		=> "icomoon icon-facebook",
			),
			array(
				"module_id"		=> $module_data["mod_id"],
				"item_name"		=> "Google+",
				"item_icon"		=> "icomoon icon-google-plus",
			),
			array(
				"module_id"		=> $module_data["mod_id"],
				"item_name"		=> "Email",
				"item_icon"		=> "icomoon icon-mail3",
			),
			array(
				"module_id"		=> $module_data["mod_id"],
				"item_name"		=> "Phone",
				"item_icon"		=> "icomoon icon-phone",
			),
		);

		foreach ($fields as $key => $val) {
			$id = $this->db->QueryInsert(
				$this->tables["plugin:team_fields"],
				$val
			);

			$this->db->QueryUpdate(
				$this->tables["plugin:team_fields"],
				array(
					"item_order"	=> $id , 
				),
				"item_id={$id}"
			);
		}
		

		$this->plugins["modules"]->CreateLangRecord(
			$this->tables["plugin:team_cats"],
			$this->tables["plugin:team_cats_lang"],
			"cat_id",
			"cat_order",
			array(
				"module_id"		=> $module_data["mod_id"],
				"cat_title"		=> "Default Category",
				"cat_url"		=> "default-category",
				"cat_status"	=> "1",
				"cat_date"		=> time(),

				"cat_size"		=> 4,
				"cat_size_lg"	=> 4,
				"cat_size_md"	=> 4,
				"cat_size_sm"	=> 6,
				"cat_size_xs"	=> 12,
			)
		);


		//create layout

		$wid = $this->plugins["widgets"]->AddWidget(array(
			"type"			=> "cteamwidgetmenu",
			"type_name"		=> "Categories Menu",
			"title"			=> "Categories",
			"note"			=> "Auto-Generated",
			"settings"		=> array( "set_style"	=> "2"),
			"module"		=> $module_data["mod_id"],
		));


		$widgets = array("__CONTENT__");

		if (is_object($this->plugins["comments"])) {
			$widgets[] = $this->plugins["comments"]->GetCommentsWidget();
		}
		


		$layout = $this->plugins["layouts"]->SaveLayout(
			array(
				"name"			=> $module_data["mod_name"] . " - Details",
				"block"			=> array(
					"col"	=> array(

						0 => array("size"	=> 4 , "widget"	=> $wid),
						1 => array("size"	=> 8 , "widget"	=> $widgets),					
					)
				)				
			)
		);

		//update the layout id
		$this->plugins["modules"]->UpdateModuleSettings(
			$module_data["mod_id"] , 
			array(
				"set_layout_details"			=> $layout,
			)
		);



	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function onDelete($module_data) {

		$tables  = array(
			"plugin:team_items" , 
			"plugin:team_items_lang",
			"plugin:team_fields",
			"plugin:team_fields_values",
			"plugin:team_cats" , 
			"plugin:team_cats_lang",
		);

		foreach ($tables as $key => $val) {
			$this->db->Query(
				"DELETE FROM " . $this->tables[$val] . " WHERE module_id={$module_data[mod_id]}"
			);
		}

		parent::onDelete($module_data);	
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function PrepareTeamFields(&$forms) {

		$fields = $this->db->QFetchRowArray("SELECT * FROM {$this->tables['plugin:team_fields']} WHERE module_id=%d ORDER BY item_order ASC" , array($_REQUEST["module_id"]));

		if (is_array($fields)) {
			foreach ($fields as $key => $val) {

				$forms["add"]["fields"]["box"]["0"]["fields"][] = 
				$forms["edit"]["fields"]["box"]["0"]["fields"][] = 
				$forms["details"]["fields"]["box"]["0"]["fields"][] = array(
					"name"	=> "val_" . $val["item_id"],
					"type"	=> "textbox",
					"width"	=> "100%",
					"title"	=> $val["item_name"]
				);
			}
			
		}
		
		
	}

	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function TeamStoreFields($record) {

		if (is_Array($record)) {
			foreach ($record as $k => $v) {

				if (stristr($k , "val_")) {

					$k = str_replace("val_" , "" , $k);

					$old = $this->db->QFetchArray("			
						SELECT * FROM 
							{$this->tables['plugin:team_fields_values']}
						WHERE
							team_id = %d AND
							field_id = %d AND 
							module_id = %d
							
						",
						array(
							$record["item_id"],
							$k , 
							$record["module_id"]
						)
					);

					if (is_array($old)) {				
						$this->db->QueryUpdate(
							$this->tables["plugin:team_fields_values"],
							array(
								"val_value"	=> $v
							),
							"val_id={$old[val_id]}"
						);
					} else {
						$this->db->QueryInsert(
							$this->tables["plugin:team_fields_values"],
							array(
								"module_id"	=> $record["module_id"],
								"team_id"	=> $record["item_id"],
								"field_id"	=> $k , 
								"val_value"	=> $v
							)
						);
					}
				
				}
				
			}
			
		}
		
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function TeamSocialValues($data) {

		$values = $this->db->QFetchRowArray("
			SELECT * FROM 
				{$this->tables['plugin:team_fields_values']}
			WHERE
				team_id = %d AND 
				module_id = %d
			",
			array(
				$data["item_id"],
				$data["module_id"]
			)
		);

		if (is_array($values)) {
			foreach ($values as $key => $val) {
				$data["val_" . $val["field_id"]] = $val["val_value"];
			}			
		}

		return $data;
	}
	
}

?>